<?php

// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

namespace Algolia\AlgoliaSearch\Model\Composition;

use Algolia\AlgoliaSearch\Model\AbstractModel;
use Algolia\AlgoliaSearch\Model\ModelInterface;

/**
 * BaseInjectionQueryParameters Class Doc Comment.
 *
 * @category Class
 */
class BaseInjectionQueryParameters extends AbstractModel implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $modelTypes = [
        'advancedSyntax' => 'bool',
        'advancedSyntaxFeatures' => '\Algolia\AlgoliaSearch\Model\Composition\AdvancedSyntaxFeatures[]',
        'allowTyposOnNumericTokens' => 'bool',
        'alternativesAsExact' => '\Algolia\AlgoliaSearch\Model\Composition\AlternativesAsExact[]',
        'analytics' => 'bool',
        'attributeCriteriaComputedByMinProximity' => 'bool',
        'attributesToHighlight' => 'string[]',
        'attributesToRetrieve' => 'string[]',
        'attributesToSnippet' => 'string[]',
        'clickAnalytics' => 'bool',
        'decompoundQuery' => 'bool',
        'disableExactOnAttributes' => 'string[]',
        'disableTypoToleranceOnAttributes' => 'string[]',
        'distinct' => '\Algolia\AlgoliaSearch\Model\Composition\Distinct',
        'enableABTest' => 'bool',
        'enablePersonalization' => 'bool',
        'enableReRanking' => 'bool',
        'enableRules' => 'bool',
        'exactOnSingleWordQuery' => '\Algolia\AlgoliaSearch\Model\Composition\ExactOnSingleWordQuery',
        'facetFilters' => '\Algolia\AlgoliaSearch\Model\Composition\FacetFilters',
        'filters' => 'string',
        'getRankingInfo' => 'bool',
        'highlightPostTag' => 'string',
        'highlightPreTag' => 'string',
        'ignorePlurals' => '\Algolia\AlgoliaSearch\Model\Composition\IgnorePlurals',
        'maxFacetHits' => 'int',
        'minProximity' => 'int',
        'minWordSizefor1Typo' => 'int',
        'minWordSizefor2Typos' => 'int',
        'naturalLanguages' => '\Algolia\AlgoliaSearch\Model\Composition\SupportedLanguage[]',
        'numericFilters' => '\Algolia\AlgoliaSearch\Model\Composition\NumericFilters',
        'optionalFilters' => '\Algolia\AlgoliaSearch\Model\Composition\OptionalFilters',
        'optionalWords' => '\Algolia\AlgoliaSearch\Model\Composition\OptionalWords',
        'percentileComputation' => 'bool',
        'personalizationImpact' => 'int',
        'queryLanguages' => '\Algolia\AlgoliaSearch\Model\Composition\SupportedLanguage[]',
        'queryType' => '\Algolia\AlgoliaSearch\Model\Composition\QueryType',
        'removeStopWords' => '\Algolia\AlgoliaSearch\Model\Composition\RemoveStopWords',
        'removeWordsIfNoResults' => '\Algolia\AlgoliaSearch\Model\Composition\RemoveWordsIfNoResults',
        'replaceSynonymsInHighlight' => 'bool',
        'responseFields' => 'string[]',
        'restrictHighlightAndSnippetArrays' => 'bool',
        'restrictSearchableAttributes' => 'string[]',
        'ruleContexts' => 'string[]',
        'snippetEllipsisText' => 'string',
        'synonyms' => 'bool',
        'typoTolerance' => '\Algolia\AlgoliaSearch\Model\Composition\TypoTolerance',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $modelFormats = [
        'advancedSyntax' => null,
        'advancedSyntaxFeatures' => null,
        'allowTyposOnNumericTokens' => null,
        'alternativesAsExact' => null,
        'analytics' => null,
        'attributeCriteriaComputedByMinProximity' => null,
        'attributesToHighlight' => null,
        'attributesToRetrieve' => null,
        'attributesToSnippet' => null,
        'clickAnalytics' => null,
        'decompoundQuery' => null,
        'disableExactOnAttributes' => null,
        'disableTypoToleranceOnAttributes' => null,
        'distinct' => null,
        'enableABTest' => null,
        'enablePersonalization' => null,
        'enableReRanking' => null,
        'enableRules' => null,
        'exactOnSingleWordQuery' => null,
        'facetFilters' => null,
        'filters' => null,
        'getRankingInfo' => null,
        'highlightPostTag' => null,
        'highlightPreTag' => null,
        'ignorePlurals' => null,
        'maxFacetHits' => null,
        'minProximity' => null,
        'minWordSizefor1Typo' => null,
        'minWordSizefor2Typos' => null,
        'naturalLanguages' => null,
        'numericFilters' => null,
        'optionalFilters' => null,
        'optionalWords' => null,
        'percentileComputation' => null,
        'personalizationImpact' => null,
        'queryLanguages' => null,
        'queryType' => null,
        'removeStopWords' => null,
        'removeWordsIfNoResults' => null,
        'replaceSynonymsInHighlight' => null,
        'responseFields' => null,
        'restrictHighlightAndSnippetArrays' => null,
        'restrictSearchableAttributes' => null,
        'ruleContexts' => null,
        'snippetEllipsisText' => null,
        'synonyms' => null,
        'typoTolerance' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'advancedSyntax' => 'advancedSyntax',
        'advancedSyntaxFeatures' => 'advancedSyntaxFeatures',
        'allowTyposOnNumericTokens' => 'allowTyposOnNumericTokens',
        'alternativesAsExact' => 'alternativesAsExact',
        'analytics' => 'analytics',
        'attributeCriteriaComputedByMinProximity' => 'attributeCriteriaComputedByMinProximity',
        'attributesToHighlight' => 'attributesToHighlight',
        'attributesToRetrieve' => 'attributesToRetrieve',
        'attributesToSnippet' => 'attributesToSnippet',
        'clickAnalytics' => 'clickAnalytics',
        'decompoundQuery' => 'decompoundQuery',
        'disableExactOnAttributes' => 'disableExactOnAttributes',
        'disableTypoToleranceOnAttributes' => 'disableTypoToleranceOnAttributes',
        'distinct' => 'distinct',
        'enableABTest' => 'enableABTest',
        'enablePersonalization' => 'enablePersonalization',
        'enableReRanking' => 'enableReRanking',
        'enableRules' => 'enableRules',
        'exactOnSingleWordQuery' => 'exactOnSingleWordQuery',
        'facetFilters' => 'facetFilters',
        'filters' => 'filters',
        'getRankingInfo' => 'getRankingInfo',
        'highlightPostTag' => 'highlightPostTag',
        'highlightPreTag' => 'highlightPreTag',
        'ignorePlurals' => 'ignorePlurals',
        'maxFacetHits' => 'maxFacetHits',
        'minProximity' => 'minProximity',
        'minWordSizefor1Typo' => 'minWordSizefor1Typo',
        'minWordSizefor2Typos' => 'minWordSizefor2Typos',
        'naturalLanguages' => 'naturalLanguages',
        'numericFilters' => 'numericFilters',
        'optionalFilters' => 'optionalFilters',
        'optionalWords' => 'optionalWords',
        'percentileComputation' => 'percentileComputation',
        'personalizationImpact' => 'personalizationImpact',
        'queryLanguages' => 'queryLanguages',
        'queryType' => 'queryType',
        'removeStopWords' => 'removeStopWords',
        'removeWordsIfNoResults' => 'removeWordsIfNoResults',
        'replaceSynonymsInHighlight' => 'replaceSynonymsInHighlight',
        'responseFields' => 'responseFields',
        'restrictHighlightAndSnippetArrays' => 'restrictHighlightAndSnippetArrays',
        'restrictSearchableAttributes' => 'restrictSearchableAttributes',
        'ruleContexts' => 'ruleContexts',
        'snippetEllipsisText' => 'snippetEllipsisText',
        'synonyms' => 'synonyms',
        'typoTolerance' => 'typoTolerance',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'advancedSyntax' => 'setAdvancedSyntax',
        'advancedSyntaxFeatures' => 'setAdvancedSyntaxFeatures',
        'allowTyposOnNumericTokens' => 'setAllowTyposOnNumericTokens',
        'alternativesAsExact' => 'setAlternativesAsExact',
        'analytics' => 'setAnalytics',
        'attributeCriteriaComputedByMinProximity' => 'setAttributeCriteriaComputedByMinProximity',
        'attributesToHighlight' => 'setAttributesToHighlight',
        'attributesToRetrieve' => 'setAttributesToRetrieve',
        'attributesToSnippet' => 'setAttributesToSnippet',
        'clickAnalytics' => 'setClickAnalytics',
        'decompoundQuery' => 'setDecompoundQuery',
        'disableExactOnAttributes' => 'setDisableExactOnAttributes',
        'disableTypoToleranceOnAttributes' => 'setDisableTypoToleranceOnAttributes',
        'distinct' => 'setDistinct',
        'enableABTest' => 'setEnableABTest',
        'enablePersonalization' => 'setEnablePersonalization',
        'enableReRanking' => 'setEnableReRanking',
        'enableRules' => 'setEnableRules',
        'exactOnSingleWordQuery' => 'setExactOnSingleWordQuery',
        'facetFilters' => 'setFacetFilters',
        'filters' => 'setFilters',
        'getRankingInfo' => 'setGetRankingInfo',
        'highlightPostTag' => 'setHighlightPostTag',
        'highlightPreTag' => 'setHighlightPreTag',
        'ignorePlurals' => 'setIgnorePlurals',
        'maxFacetHits' => 'setMaxFacetHits',
        'minProximity' => 'setMinProximity',
        'minWordSizefor1Typo' => 'setMinWordSizefor1Typo',
        'minWordSizefor2Typos' => 'setMinWordSizefor2Typos',
        'naturalLanguages' => 'setNaturalLanguages',
        'numericFilters' => 'setNumericFilters',
        'optionalFilters' => 'setOptionalFilters',
        'optionalWords' => 'setOptionalWords',
        'percentileComputation' => 'setPercentileComputation',
        'personalizationImpact' => 'setPersonalizationImpact',
        'queryLanguages' => 'setQueryLanguages',
        'queryType' => 'setQueryType',
        'removeStopWords' => 'setRemoveStopWords',
        'removeWordsIfNoResults' => 'setRemoveWordsIfNoResults',
        'replaceSynonymsInHighlight' => 'setReplaceSynonymsInHighlight',
        'responseFields' => 'setResponseFields',
        'restrictHighlightAndSnippetArrays' => 'setRestrictHighlightAndSnippetArrays',
        'restrictSearchableAttributes' => 'setRestrictSearchableAttributes',
        'ruleContexts' => 'setRuleContexts',
        'snippetEllipsisText' => 'setSnippetEllipsisText',
        'synonyms' => 'setSynonyms',
        'typoTolerance' => 'setTypoTolerance',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'advancedSyntax' => 'getAdvancedSyntax',
        'advancedSyntaxFeatures' => 'getAdvancedSyntaxFeatures',
        'allowTyposOnNumericTokens' => 'getAllowTyposOnNumericTokens',
        'alternativesAsExact' => 'getAlternativesAsExact',
        'analytics' => 'getAnalytics',
        'attributeCriteriaComputedByMinProximity' => 'getAttributeCriteriaComputedByMinProximity',
        'attributesToHighlight' => 'getAttributesToHighlight',
        'attributesToRetrieve' => 'getAttributesToRetrieve',
        'attributesToSnippet' => 'getAttributesToSnippet',
        'clickAnalytics' => 'getClickAnalytics',
        'decompoundQuery' => 'getDecompoundQuery',
        'disableExactOnAttributes' => 'getDisableExactOnAttributes',
        'disableTypoToleranceOnAttributes' => 'getDisableTypoToleranceOnAttributes',
        'distinct' => 'getDistinct',
        'enableABTest' => 'getEnableABTest',
        'enablePersonalization' => 'getEnablePersonalization',
        'enableReRanking' => 'getEnableReRanking',
        'enableRules' => 'getEnableRules',
        'exactOnSingleWordQuery' => 'getExactOnSingleWordQuery',
        'facetFilters' => 'getFacetFilters',
        'filters' => 'getFilters',
        'getRankingInfo' => 'getGetRankingInfo',
        'highlightPostTag' => 'getHighlightPostTag',
        'highlightPreTag' => 'getHighlightPreTag',
        'ignorePlurals' => 'getIgnorePlurals',
        'maxFacetHits' => 'getMaxFacetHits',
        'minProximity' => 'getMinProximity',
        'minWordSizefor1Typo' => 'getMinWordSizefor1Typo',
        'minWordSizefor2Typos' => 'getMinWordSizefor2Typos',
        'naturalLanguages' => 'getNaturalLanguages',
        'numericFilters' => 'getNumericFilters',
        'optionalFilters' => 'getOptionalFilters',
        'optionalWords' => 'getOptionalWords',
        'percentileComputation' => 'getPercentileComputation',
        'personalizationImpact' => 'getPersonalizationImpact',
        'queryLanguages' => 'getQueryLanguages',
        'queryType' => 'getQueryType',
        'removeStopWords' => 'getRemoveStopWords',
        'removeWordsIfNoResults' => 'getRemoveWordsIfNoResults',
        'replaceSynonymsInHighlight' => 'getReplaceSynonymsInHighlight',
        'responseFields' => 'getResponseFields',
        'restrictHighlightAndSnippetArrays' => 'getRestrictHighlightAndSnippetArrays',
        'restrictSearchableAttributes' => 'getRestrictSearchableAttributes',
        'ruleContexts' => 'getRuleContexts',
        'snippetEllipsisText' => 'getSnippetEllipsisText',
        'synonyms' => 'getSynonyms',
        'typoTolerance' => 'getTypoTolerance',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     */
    public function __construct(?array $data = null)
    {
        if (isset($data['advancedSyntax'])) {
            $this->container['advancedSyntax'] = $data['advancedSyntax'];
        }
        if (isset($data['advancedSyntaxFeatures'])) {
            $this->container['advancedSyntaxFeatures'] = $data['advancedSyntaxFeatures'];
        }
        if (isset($data['allowTyposOnNumericTokens'])) {
            $this->container['allowTyposOnNumericTokens'] = $data['allowTyposOnNumericTokens'];
        }
        if (isset($data['alternativesAsExact'])) {
            $this->container['alternativesAsExact'] = $data['alternativesAsExact'];
        }
        if (isset($data['analytics'])) {
            $this->container['analytics'] = $data['analytics'];
        }
        if (isset($data['attributeCriteriaComputedByMinProximity'])) {
            $this->container['attributeCriteriaComputedByMinProximity'] = $data['attributeCriteriaComputedByMinProximity'];
        }
        if (isset($data['attributesToHighlight'])) {
            $this->container['attributesToHighlight'] = $data['attributesToHighlight'];
        }
        if (isset($data['attributesToRetrieve'])) {
            $this->container['attributesToRetrieve'] = $data['attributesToRetrieve'];
        }
        if (isset($data['attributesToSnippet'])) {
            $this->container['attributesToSnippet'] = $data['attributesToSnippet'];
        }
        if (isset($data['clickAnalytics'])) {
            $this->container['clickAnalytics'] = $data['clickAnalytics'];
        }
        if (isset($data['decompoundQuery'])) {
            $this->container['decompoundQuery'] = $data['decompoundQuery'];
        }
        if (isset($data['disableExactOnAttributes'])) {
            $this->container['disableExactOnAttributes'] = $data['disableExactOnAttributes'];
        }
        if (isset($data['disableTypoToleranceOnAttributes'])) {
            $this->container['disableTypoToleranceOnAttributes'] = $data['disableTypoToleranceOnAttributes'];
        }
        if (isset($data['distinct'])) {
            $this->container['distinct'] = $data['distinct'];
        }
        if (isset($data['enableABTest'])) {
            $this->container['enableABTest'] = $data['enableABTest'];
        }
        if (isset($data['enablePersonalization'])) {
            $this->container['enablePersonalization'] = $data['enablePersonalization'];
        }
        if (isset($data['enableReRanking'])) {
            $this->container['enableReRanking'] = $data['enableReRanking'];
        }
        if (isset($data['enableRules'])) {
            $this->container['enableRules'] = $data['enableRules'];
        }
        if (isset($data['exactOnSingleWordQuery'])) {
            $this->container['exactOnSingleWordQuery'] = $data['exactOnSingleWordQuery'];
        }
        if (isset($data['facetFilters'])) {
            $this->container['facetFilters'] = $data['facetFilters'];
        }
        if (isset($data['filters'])) {
            $this->container['filters'] = $data['filters'];
        }
        if (isset($data['getRankingInfo'])) {
            $this->container['getRankingInfo'] = $data['getRankingInfo'];
        }
        if (isset($data['highlightPostTag'])) {
            $this->container['highlightPostTag'] = $data['highlightPostTag'];
        }
        if (isset($data['highlightPreTag'])) {
            $this->container['highlightPreTag'] = $data['highlightPreTag'];
        }
        if (isset($data['ignorePlurals'])) {
            $this->container['ignorePlurals'] = $data['ignorePlurals'];
        }
        if (isset($data['maxFacetHits'])) {
            $this->container['maxFacetHits'] = $data['maxFacetHits'];
        }
        if (isset($data['minProximity'])) {
            $this->container['minProximity'] = $data['minProximity'];
        }
        if (isset($data['minWordSizefor1Typo'])) {
            $this->container['minWordSizefor1Typo'] = $data['minWordSizefor1Typo'];
        }
        if (isset($data['minWordSizefor2Typos'])) {
            $this->container['minWordSizefor2Typos'] = $data['minWordSizefor2Typos'];
        }
        if (isset($data['naturalLanguages'])) {
            $this->container['naturalLanguages'] = $data['naturalLanguages'];
        }
        if (isset($data['numericFilters'])) {
            $this->container['numericFilters'] = $data['numericFilters'];
        }
        if (isset($data['optionalFilters'])) {
            $this->container['optionalFilters'] = $data['optionalFilters'];
        }
        if (isset($data['optionalWords'])) {
            $this->container['optionalWords'] = $data['optionalWords'];
        }
        if (isset($data['percentileComputation'])) {
            $this->container['percentileComputation'] = $data['percentileComputation'];
        }
        if (isset($data['personalizationImpact'])) {
            $this->container['personalizationImpact'] = $data['personalizationImpact'];
        }
        if (isset($data['queryLanguages'])) {
            $this->container['queryLanguages'] = $data['queryLanguages'];
        }
        if (isset($data['queryType'])) {
            $this->container['queryType'] = $data['queryType'];
        }
        if (isset($data['removeStopWords'])) {
            $this->container['removeStopWords'] = $data['removeStopWords'];
        }
        if (isset($data['removeWordsIfNoResults'])) {
            $this->container['removeWordsIfNoResults'] = $data['removeWordsIfNoResults'];
        }
        if (isset($data['replaceSynonymsInHighlight'])) {
            $this->container['replaceSynonymsInHighlight'] = $data['replaceSynonymsInHighlight'];
        }
        if (isset($data['responseFields'])) {
            $this->container['responseFields'] = $data['responseFields'];
        }
        if (isset($data['restrictHighlightAndSnippetArrays'])) {
            $this->container['restrictHighlightAndSnippetArrays'] = $data['restrictHighlightAndSnippetArrays'];
        }
        if (isset($data['restrictSearchableAttributes'])) {
            $this->container['restrictSearchableAttributes'] = $data['restrictSearchableAttributes'];
        }
        if (isset($data['ruleContexts'])) {
            $this->container['ruleContexts'] = $data['ruleContexts'];
        }
        if (isset($data['snippetEllipsisText'])) {
            $this->container['snippetEllipsisText'] = $data['snippetEllipsisText'];
        }
        if (isset($data['synonyms'])) {
            $this->container['synonyms'] = $data['synonyms'];
        }
        if (isset($data['typoTolerance'])) {
            $this->container['typoTolerance'] = $data['typoTolerance'];
        }
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function modelTypes()
    {
        return self::$modelTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function modelFormats()
    {
        return self::$modelFormats;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        return [];
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets advancedSyntax.
     *
     * @return null|bool
     */
    public function getAdvancedSyntax()
    {
        return $this->container['advancedSyntax'] ?? null;
    }

    /**
     * Sets advancedSyntax.
     *
     * @param null|bool $advancedSyntax whether to support phrase matching and excluding words from search queries Use the `advancedSyntaxFeatures` parameter to control which feature is supported
     *
     * @return self
     */
    public function setAdvancedSyntax($advancedSyntax)
    {
        $this->container['advancedSyntax'] = $advancedSyntax;

        return $this;
    }

    /**
     * Gets advancedSyntaxFeatures.
     *
     * @return null|AdvancedSyntaxFeatures[]
     */
    public function getAdvancedSyntaxFeatures()
    {
        return $this->container['advancedSyntaxFeatures'] ?? null;
    }

    /**
     * Sets advancedSyntaxFeatures.
     *
     * @param null|AdvancedSyntaxFeatures[] $advancedSyntaxFeatures Advanced search syntax features you want to support - `exactPhrase`.   Phrases in quotes must match exactly.   For example, `sparkly blue \"iPhone case\"` only returns records with the exact string \"iPhone case\" - `excludeWords`.   Query words prefixed with a `-` must not occur in a record.   For example, `search -engine` matches records that contain \"search\" but not \"engine\" This setting only has an effect if `advancedSyntax` is true.
     *
     * @return self
     */
    public function setAdvancedSyntaxFeatures($advancedSyntaxFeatures)
    {
        $this->container['advancedSyntaxFeatures'] = $advancedSyntaxFeatures;

        return $this;
    }

    /**
     * Gets allowTyposOnNumericTokens.
     *
     * @return null|bool
     */
    public function getAllowTyposOnNumericTokens()
    {
        return $this->container['allowTyposOnNumericTokens'] ?? null;
    }

    /**
     * Sets allowTyposOnNumericTokens.
     *
     * @param null|bool $allowTyposOnNumericTokens whether to allow typos on numbers in the search query Turn off this setting to reduce the number of irrelevant matches when searching in large sets of similar numbers
     *
     * @return self
     */
    public function setAllowTyposOnNumericTokens($allowTyposOnNumericTokens)
    {
        $this->container['allowTyposOnNumericTokens'] = $allowTyposOnNumericTokens;

        return $this;
    }

    /**
     * Gets alternativesAsExact.
     *
     * @return null|AlternativesAsExact[]
     */
    public function getAlternativesAsExact()
    {
        return $this->container['alternativesAsExact'] ?? null;
    }

    /**
     * Sets alternativesAsExact.
     *
     * @param null|AlternativesAsExact[] $alternativesAsExact Determine which plurals and synonyms should be considered an exact matches By default, Algolia treats singular and plural forms of a word, and single-word synonyms, as [exact](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/#exact) matches when searching. For example - \"swimsuit\" and \"swimsuits\" are treated the same - \"swimsuit\" and \"swimwear\" are treated the same (if they are [synonyms](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#regular-synonyms)) - `ignorePlurals`.   Plurals and similar declensions added by the `ignorePlurals` setting are considered exact matches - `singleWordSynonym`.   Single-word synonyms, such as \"NY\" = \"NYC\", are considered exact matches - `multiWordsSynonym`.   Multi-word synonyms, such as \"NY\" = \"New York\", are considered exact matches.
     *
     * @return self
     */
    public function setAlternativesAsExact($alternativesAsExact)
    {
        $this->container['alternativesAsExact'] = $alternativesAsExact;

        return $this;
    }

    /**
     * Gets analytics.
     *
     * @return null|bool
     */
    public function getAnalytics()
    {
        return $this->container['analytics'] ?? null;
    }

    /**
     * Sets analytics.
     *
     * @param null|bool $analytics whether this search will be included in Analytics
     *
     * @return self
     */
    public function setAnalytics($analytics)
    {
        $this->container['analytics'] = $analytics;

        return $this;
    }

    /**
     * Gets attributeCriteriaComputedByMinProximity.
     *
     * @return null|bool
     */
    public function getAttributeCriteriaComputedByMinProximity()
    {
        return $this->container['attributeCriteriaComputedByMinProximity'] ?? null;
    }

    /**
     * Sets attributeCriteriaComputedByMinProximity.
     *
     * @param null|bool $attributeCriteriaComputedByMinProximity Whether the best matching attribute should be determined by minimum proximity This setting only affects ranking if the Attribute ranking criterion comes before Proximity in the `ranking` setting. If true, the best matching attribute is selected based on the minimum proximity of multiple matches. Otherwise, the best matching attribute is determined by the order in the `searchableAttributes` setting.
     *
     * @return self
     */
    public function setAttributeCriteriaComputedByMinProximity($attributeCriteriaComputedByMinProximity)
    {
        $this->container['attributeCriteriaComputedByMinProximity'] = $attributeCriteriaComputedByMinProximity;

        return $this;
    }

    /**
     * Gets attributesToHighlight.
     *
     * @return null|string[]
     */
    public function getAttributesToHighlight()
    {
        return $this->container['attributesToHighlight'] ?? null;
    }

    /**
     * Sets attributesToHighlight.
     *
     * @param null|string[] $attributesToHighlight Attributes to highlight By default, all searchable attributes are highlighted. Use `*` to highlight all attributes or use an empty array `[]` to turn off highlighting. Attribute names are case-sensitive With highlighting, strings that match the search query are surrounded by HTML tags defined by `highlightPreTag` and `highlightPostTag`. You can use this to visually highlight matching parts of a search query in your UI For more information, see [Highlighting and snippeting](https://www.algolia.com/doc/guides/building-search-ui/ui-and-ux-patterns/highlighting-snippeting/js).
     *
     * @return self
     */
    public function setAttributesToHighlight($attributesToHighlight)
    {
        $this->container['attributesToHighlight'] = $attributesToHighlight;

        return $this;
    }

    /**
     * Gets attributesToRetrieve.
     *
     * @return null|string[]
     */
    public function getAttributesToRetrieve()
    {
        return $this->container['attributesToRetrieve'] ?? null;
    }

    /**
     * Sets attributesToRetrieve.
     *
     * @param null|string[] $attributesToRetrieve Attributes to include in the API response To reduce the size of your response, you can retrieve only some of the attributes. Attribute names are case-sensitive - `*` retrieves all attributes, except attributes included in the `customRanking` and `unretrievableAttributes` settings. - To retrieve all attributes except a specific one, prefix the attribute with a dash and combine it with the `*`: `[\"*\", \"-ATTRIBUTE\"]`. - The `objectID` attribute is always included.
     *
     * @return self
     */
    public function setAttributesToRetrieve($attributesToRetrieve)
    {
        $this->container['attributesToRetrieve'] = $attributesToRetrieve;

        return $this;
    }

    /**
     * Gets attributesToSnippet.
     *
     * @return null|string[]
     */
    public function getAttributesToSnippet()
    {
        return $this->container['attributesToSnippet'] ?? null;
    }

    /**
     * Sets attributesToSnippet.
     *
     * @param null|string[] $attributesToSnippet Attributes for which to enable snippets. Attribute names are case-sensitive Snippets provide additional context to matched words. If you enable snippets, they include 10 words, including the matched word. The matched word will also be wrapped by HTML tags for highlighting. You can adjust the number of words with the following notation: `ATTRIBUTE:NUMBER`, where `NUMBER` is the number of words to be extracted.
     *
     * @return self
     */
    public function setAttributesToSnippet($attributesToSnippet)
    {
        $this->container['attributesToSnippet'] = $attributesToSnippet;

        return $this;
    }

    /**
     * Gets clickAnalytics.
     *
     * @return null|bool
     */
    public function getClickAnalytics()
    {
        return $this->container['clickAnalytics'] ?? null;
    }

    /**
     * Sets clickAnalytics.
     *
     * @param null|bool $clickAnalytics Whether to include a `queryID` attribute in the response The query ID is a unique identifier for a search query and is required for tracking [click and conversion events](https://www.algolia.com/doc/guides/sending-events/getting-started).
     *
     * @return self
     */
    public function setClickAnalytics($clickAnalytics)
    {
        $this->container['clickAnalytics'] = $clickAnalytics;

        return $this;
    }

    /**
     * Gets decompoundQuery.
     *
     * @return null|bool
     */
    public function getDecompoundQuery()
    {
        return $this->container['decompoundQuery'] ?? null;
    }

    /**
     * Sets decompoundQuery.
     *
     * @param null|bool $decompoundQuery Whether to split compound words in the query into their building blocks For more information, see [Word segmentation](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/#splitting-compound-words). Word segmentation is supported for these languages: German, Dutch, Finnish, Swedish, and Norwegian. Decompounding doesn't work for words with [non-spacing mark Unicode characters](https://www.charactercodes.net/category/non-spacing_mark). For example, `Gartenstühle` won't be decompounded if the `ü` consists of `u` (U+0075) and `◌̈` (U+0308).
     *
     * @return self
     */
    public function setDecompoundQuery($decompoundQuery)
    {
        $this->container['decompoundQuery'] = $decompoundQuery;

        return $this;
    }

    /**
     * Gets disableExactOnAttributes.
     *
     * @return null|string[]
     */
    public function getDisableExactOnAttributes()
    {
        return $this->container['disableExactOnAttributes'] ?? null;
    }

    /**
     * Sets disableExactOnAttributes.
     *
     * @param null|string[] $disableExactOnAttributes Searchable attributes for which you want to [turn off the Exact ranking criterion](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/override-search-engine-defaults/in-depth/adjust-exact-settings/#turn-off-exact-for-some-attributes). Attribute names are case-sensitive This can be useful for attributes with long values, where the likelihood of an exact match is high, such as product descriptions. Turning off the Exact ranking criterion for these attributes favors exact matching on other attributes. This reduces the impact of individual attributes with a lot of content on ranking.
     *
     * @return self
     */
    public function setDisableExactOnAttributes($disableExactOnAttributes)
    {
        $this->container['disableExactOnAttributes'] = $disableExactOnAttributes;

        return $this;
    }

    /**
     * Gets disableTypoToleranceOnAttributes.
     *
     * @return null|string[]
     */
    public function getDisableTypoToleranceOnAttributes()
    {
        return $this->container['disableTypoToleranceOnAttributes'] ?? null;
    }

    /**
     * Sets disableTypoToleranceOnAttributes.
     *
     * @param null|string[] $disableTypoToleranceOnAttributes Attributes for which you want to turn off [typo tolerance](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance). Attribute names are case-sensitive Returning only exact matches can help when - [Searching in hyphenated attributes](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/how-to/how-to-search-in-hyphenated-attributes). - Reducing the number of matches when you have too many.   This can happen with attributes that are long blocks of text, such as product descriptions Consider alternatives such as `disableTypoToleranceOnWords` or adding synonyms if your attributes have intentional unusual spellings that might look like typos.
     *
     * @return self
     */
    public function setDisableTypoToleranceOnAttributes($disableTypoToleranceOnAttributes)
    {
        $this->container['disableTypoToleranceOnAttributes'] = $disableTypoToleranceOnAttributes;

        return $this;
    }

    /**
     * Gets distinct.
     *
     * @return null|Distinct
     */
    public function getDistinct()
    {
        return $this->container['distinct'] ?? null;
    }

    /**
     * Sets distinct.
     *
     * @param null|Distinct $distinct distinct
     *
     * @return self
     */
    public function setDistinct($distinct)
    {
        $this->container['distinct'] = $distinct;

        return $this;
    }

    /**
     * Gets enableABTest.
     *
     * @return null|bool
     */
    public function getEnableABTest()
    {
        return $this->container['enableABTest'] ?? null;
    }

    /**
     * Sets enableABTest.
     *
     * @param null|bool $enableABTest whether to enable A/B testing for this search
     *
     * @return self
     */
    public function setEnableABTest($enableABTest)
    {
        $this->container['enableABTest'] = $enableABTest;

        return $this;
    }

    /**
     * Gets enablePersonalization.
     *
     * @return null|bool
     */
    public function getEnablePersonalization()
    {
        return $this->container['enablePersonalization'] ?? null;
    }

    /**
     * Sets enablePersonalization.
     *
     * @param null|bool $enablePersonalization whether to enable Personalization
     *
     * @return self
     */
    public function setEnablePersonalization($enablePersonalization)
    {
        $this->container['enablePersonalization'] = $enablePersonalization;

        return $this;
    }

    /**
     * Gets enableReRanking.
     *
     * @return null|bool
     */
    public function getEnableReRanking()
    {
        return $this->container['enableReRanking'] ?? null;
    }

    /**
     * Sets enableReRanking.
     *
     * @param null|bool $enableReRanking Whether this search will use [Dynamic Re-Ranking](https://www.algolia.com/doc/guides/algolia-ai/re-ranking) This setting only has an effect if you activated Dynamic Re-Ranking for this index in the Algolia dashboard.
     *
     * @return self
     */
    public function setEnableReRanking($enableReRanking)
    {
        $this->container['enableReRanking'] = $enableReRanking;

        return $this;
    }

    /**
     * Gets enableRules.
     *
     * @return null|bool
     */
    public function getEnableRules()
    {
        return $this->container['enableRules'] ?? null;
    }

    /**
     * Sets enableRules.
     *
     * @param null|bool $enableRules whether to enable rules
     *
     * @return self
     */
    public function setEnableRules($enableRules)
    {
        $this->container['enableRules'] = $enableRules;

        return $this;
    }

    /**
     * Gets exactOnSingleWordQuery.
     *
     * @return null|ExactOnSingleWordQuery
     */
    public function getExactOnSingleWordQuery()
    {
        return $this->container['exactOnSingleWordQuery'] ?? null;
    }

    /**
     * Sets exactOnSingleWordQuery.
     *
     * @param null|ExactOnSingleWordQuery $exactOnSingleWordQuery exactOnSingleWordQuery
     *
     * @return self
     */
    public function setExactOnSingleWordQuery($exactOnSingleWordQuery)
    {
        $this->container['exactOnSingleWordQuery'] = $exactOnSingleWordQuery;

        return $this;
    }

    /**
     * Gets facetFilters.
     *
     * @return null|FacetFilters
     */
    public function getFacetFilters()
    {
        return $this->container['facetFilters'] ?? null;
    }

    /**
     * Sets facetFilters.
     *
     * @param null|FacetFilters $facetFilters facetFilters
     *
     * @return self
     */
    public function setFacetFilters($facetFilters)
    {
        $this->container['facetFilters'] = $facetFilters;

        return $this;
    }

    /**
     * Gets filters.
     *
     * @return null|string
     */
    public function getFilters()
    {
        return $this->container['filters'] ?? null;
    }

    /**
     * Sets filters.
     *
     * @param null|string $filters Filter expression to only include items that match the filter criteria in the response.  You can use these filter expressions:  - **Numeric filters.** `<facet> <op> <number>`, where `<op>` is one of `<`, `<=`, `=`, `!=`, `>`, `>=`. - **Ranges.** `<facet>:<lower> TO <upper>` where `<lower>` and `<upper>` are the lower and upper limits of the range (inclusive). - **Facet filters.** `<facet>:<value>` where `<facet>` is a facet attribute (case-sensitive) and `<value>` a facet value. - **Tag filters.** `_tags:<value>` or just `<value>` (case-sensitive). - **Boolean filters.** `<facet>: true | false`.  You can combine filters with `AND`, `OR`, and `NOT` operators with the following restrictions:  - You can only combine filters of the same type with `OR`.   **Not supported:** `facet:value OR num > 3`. - You can't use `NOT` with combinations of filters.   **Not supported:** `NOT(facet:value OR facet:value)` - You can't combine conjunctions (`AND`) with `OR`.   **Not supported:** `facet:value OR (facet:value AND facet:value)`  Use quotes around your filters, if the facet attribute name or facet value has spaces, keywords (`OR`, `AND`, `NOT`), or quotes. If a facet attribute is an array, the filter matches if it matches at least one element of the array.  For more information, see [Filters](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering).
     *
     * @return self
     */
    public function setFilters($filters)
    {
        $this->container['filters'] = $filters;

        return $this;
    }

    /**
     * Gets getRankingInfo.
     *
     * @return null|bool
     */
    public function getGetRankingInfo()
    {
        return $this->container['getRankingInfo'] ?? null;
    }

    /**
     * Sets getRankingInfo.
     *
     * @param null|bool $getRankingInfo whether the search response should include detailed ranking information
     *
     * @return self
     */
    public function setGetRankingInfo($getRankingInfo)
    {
        $this->container['getRankingInfo'] = $getRankingInfo;

        return $this;
    }

    /**
     * Gets highlightPostTag.
     *
     * @return null|string
     */
    public function getHighlightPostTag()
    {
        return $this->container['highlightPostTag'] ?? null;
    }

    /**
     * Sets highlightPostTag.
     *
     * @param null|string $highlightPostTag HTML tag to insert after the highlighted parts in all highlighted results and snippets
     *
     * @return self
     */
    public function setHighlightPostTag($highlightPostTag)
    {
        $this->container['highlightPostTag'] = $highlightPostTag;

        return $this;
    }

    /**
     * Gets highlightPreTag.
     *
     * @return null|string
     */
    public function getHighlightPreTag()
    {
        return $this->container['highlightPreTag'] ?? null;
    }

    /**
     * Sets highlightPreTag.
     *
     * @param null|string $highlightPreTag HTML tag to insert before the highlighted parts in all highlighted results and snippets
     *
     * @return self
     */
    public function setHighlightPreTag($highlightPreTag)
    {
        $this->container['highlightPreTag'] = $highlightPreTag;

        return $this;
    }

    /**
     * Gets ignorePlurals.
     *
     * @return null|IgnorePlurals
     */
    public function getIgnorePlurals()
    {
        return $this->container['ignorePlurals'] ?? null;
    }

    /**
     * Sets ignorePlurals.
     *
     * @param null|IgnorePlurals $ignorePlurals ignorePlurals
     *
     * @return self
     */
    public function setIgnorePlurals($ignorePlurals)
    {
        $this->container['ignorePlurals'] = $ignorePlurals;

        return $this;
    }

    /**
     * Gets maxFacetHits.
     *
     * @return null|int
     */
    public function getMaxFacetHits()
    {
        return $this->container['maxFacetHits'] ?? null;
    }

    /**
     * Sets maxFacetHits.
     *
     * @param null|int $maxFacetHits Maximum number of facet values to return when [searching for facet values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values).
     *
     * @return self
     */
    public function setMaxFacetHits($maxFacetHits)
    {
        $this->container['maxFacetHits'] = $maxFacetHits;

        return $this;
    }

    /**
     * Gets minProximity.
     *
     * @return null|int
     */
    public function getMinProximity()
    {
        return $this->container['minProximity'] ?? null;
    }

    /**
     * Sets minProximity.
     *
     * @param null|int $minProximity Minimum proximity score for two matching words This adjusts the [Proximity ranking criterion](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/#proximity) by equally scoring matches that are farther apart For example, if `minProximity` is 2, neighboring matches and matches with one word between them would have the same score.
     *
     * @return self
     */
    public function setMinProximity($minProximity)
    {
        $this->container['minProximity'] = $minProximity;

        return $this;
    }

    /**
     * Gets minWordSizefor1Typo.
     *
     * @return null|int
     */
    public function getMinWordSizefor1Typo()
    {
        return $this->container['minWordSizefor1Typo'] ?? null;
    }

    /**
     * Sets minWordSizefor1Typo.
     *
     * @param null|int $minWordSizefor1Typo Minimum number of characters a word in the search query must contain to accept matches with [one typo](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/in-depth/configuring-typo-tolerance/#configuring-word-length-for-typos).
     *
     * @return self
     */
    public function setMinWordSizefor1Typo($minWordSizefor1Typo)
    {
        $this->container['minWordSizefor1Typo'] = $minWordSizefor1Typo;

        return $this;
    }

    /**
     * Gets minWordSizefor2Typos.
     *
     * @return null|int
     */
    public function getMinWordSizefor2Typos()
    {
        return $this->container['minWordSizefor2Typos'] ?? null;
    }

    /**
     * Sets minWordSizefor2Typos.
     *
     * @param null|int $minWordSizefor2Typos Minimum number of characters a word in the search query must contain to accept matches with [two typos](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/in-depth/configuring-typo-tolerance/#configuring-word-length-for-typos).
     *
     * @return self
     */
    public function setMinWordSizefor2Typos($minWordSizefor2Typos)
    {
        $this->container['minWordSizefor2Typos'] = $minWordSizefor2Typos;

        return $this;
    }

    /**
     * Gets naturalLanguages.
     *
     * @return null|SupportedLanguage[]
     */
    public function getNaturalLanguages()
    {
        return $this->container['naturalLanguages'] ?? null;
    }

    /**
     * Sets naturalLanguages.
     *
     * @param null|SupportedLanguage[] $naturalLanguages ISO language codes that adjust settings that are useful for processing natural language queries (as opposed to keyword searches) - Sets `removeStopWords` and `ignorePlurals` to the list of provided languages. - Sets `removeWordsIfNoResults` to `allOptional`. - Adds a `natural_language` attribute to `ruleContexts` and `analyticsTags`.
     *
     * @return self
     */
    public function setNaturalLanguages($naturalLanguages)
    {
        $this->container['naturalLanguages'] = $naturalLanguages;

        return $this;
    }

    /**
     * Gets numericFilters.
     *
     * @return null|NumericFilters
     */
    public function getNumericFilters()
    {
        return $this->container['numericFilters'] ?? null;
    }

    /**
     * Sets numericFilters.
     *
     * @param null|NumericFilters $numericFilters numericFilters
     *
     * @return self
     */
    public function setNumericFilters($numericFilters)
    {
        $this->container['numericFilters'] = $numericFilters;

        return $this;
    }

    /**
     * Gets optionalFilters.
     *
     * @return null|OptionalFilters
     */
    public function getOptionalFilters()
    {
        return $this->container['optionalFilters'] ?? null;
    }

    /**
     * Sets optionalFilters.
     *
     * @param null|OptionalFilters $optionalFilters optionalFilters
     *
     * @return self
     */
    public function setOptionalFilters($optionalFilters)
    {
        $this->container['optionalFilters'] = $optionalFilters;

        return $this;
    }

    /**
     * Gets optionalWords.
     *
     * @return null|OptionalWords
     */
    public function getOptionalWords()
    {
        return $this->container['optionalWords'] ?? null;
    }

    /**
     * Sets optionalWords.
     *
     * @param null|OptionalWords $optionalWords optionalWords
     *
     * @return self
     */
    public function setOptionalWords($optionalWords)
    {
        $this->container['optionalWords'] = $optionalWords;

        return $this;
    }

    /**
     * Gets percentileComputation.
     *
     * @return null|bool
     */
    public function getPercentileComputation()
    {
        return $this->container['percentileComputation'] ?? null;
    }

    /**
     * Sets percentileComputation.
     *
     * @param null|bool $percentileComputation whether to include this search when calculating processing-time percentiles
     *
     * @return self
     */
    public function setPercentileComputation($percentileComputation)
    {
        $this->container['percentileComputation'] = $percentileComputation;

        return $this;
    }

    /**
     * Gets personalizationImpact.
     *
     * @return null|int
     */
    public function getPersonalizationImpact()
    {
        return $this->container['personalizationImpact'] ?? null;
    }

    /**
     * Sets personalizationImpact.
     *
     * @param null|int $personalizationImpact Impact that Personalization should have on this search The higher this value is, the more Personalization determines the ranking compared to other factors. For more information, see [Understanding Personalization impact](https://www.algolia.com/doc/guides/personalization/personalizing-results/in-depth/configuring-personalization/#understanding-personalization-impact).
     *
     * @return self
     */
    public function setPersonalizationImpact($personalizationImpact)
    {
        $this->container['personalizationImpact'] = $personalizationImpact;

        return $this;
    }

    /**
     * Gets queryLanguages.
     *
     * @return null|SupportedLanguage[]
     */
    public function getQueryLanguages()
    {
        return $this->container['queryLanguages'] ?? null;
    }

    /**
     * Sets queryLanguages.
     *
     * @param null|SupportedLanguage[] $queryLanguages Languages for language-specific query processing steps such as plurals, stop-word removal, and word-detection dictionaries  This setting sets a default list of languages used by the `removeStopWords` and `ignorePlurals` settings. This setting also sets a dictionary for word detection in the logogram-based [CJK](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/normalization/#normalization-for-logogram-based-languages-cjk) languages. To support this, you must place the CJK language **first**  **You should always specify a query language.** If you don't specify an indexing language, the search engine uses all [supported languages](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages), or the languages you specified with the `ignorePlurals` or `removeStopWords` parameters. This can lead to unexpected search results. For more information, see [Language-specific configuration](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations).
     *
     * @return self
     */
    public function setQueryLanguages($queryLanguages)
    {
        $this->container['queryLanguages'] = $queryLanguages;

        return $this;
    }

    /**
     * Gets queryType.
     *
     * @return null|QueryType
     */
    public function getQueryType()
    {
        return $this->container['queryType'] ?? null;
    }

    /**
     * Sets queryType.
     *
     * @param null|QueryType $queryType queryType
     *
     * @return self
     */
    public function setQueryType($queryType)
    {
        $this->container['queryType'] = $queryType;

        return $this;
    }

    /**
     * Gets removeStopWords.
     *
     * @return null|RemoveStopWords
     */
    public function getRemoveStopWords()
    {
        return $this->container['removeStopWords'] ?? null;
    }

    /**
     * Sets removeStopWords.
     *
     * @param null|RemoveStopWords $removeStopWords removeStopWords
     *
     * @return self
     */
    public function setRemoveStopWords($removeStopWords)
    {
        $this->container['removeStopWords'] = $removeStopWords;

        return $this;
    }

    /**
     * Gets removeWordsIfNoResults.
     *
     * @return null|RemoveWordsIfNoResults
     */
    public function getRemoveWordsIfNoResults()
    {
        return $this->container['removeWordsIfNoResults'] ?? null;
    }

    /**
     * Sets removeWordsIfNoResults.
     *
     * @param null|RemoveWordsIfNoResults $removeWordsIfNoResults removeWordsIfNoResults
     *
     * @return self
     */
    public function setRemoveWordsIfNoResults($removeWordsIfNoResults)
    {
        $this->container['removeWordsIfNoResults'] = $removeWordsIfNoResults;

        return $this;
    }

    /**
     * Gets replaceSynonymsInHighlight.
     *
     * @return null|bool
     */
    public function getReplaceSynonymsInHighlight()
    {
        return $this->container['replaceSynonymsInHighlight'] ?? null;
    }

    /**
     * Sets replaceSynonymsInHighlight.
     *
     * @param null|bool $replaceSynonymsInHighlight Whether to replace a highlighted word with the matched synonym By default, the original words are highlighted even if a synonym matches. For example, with `home` as a synonym for `house` and a search for `home`, records matching either \"home\" or \"house\" are included in the search results, and either \"home\" or \"house\" are highlighted With `replaceSynonymsInHighlight` set to `true`, a search for `home` still matches the same records, but all occurrences of \"house\" are replaced by \"home\" in the highlighted response.
     *
     * @return self
     */
    public function setReplaceSynonymsInHighlight($replaceSynonymsInHighlight)
    {
        $this->container['replaceSynonymsInHighlight'] = $replaceSynonymsInHighlight;

        return $this;
    }

    /**
     * Gets responseFields.
     *
     * @return null|string[]
     */
    public function getResponseFields()
    {
        return $this->container['responseFields'] ?? null;
    }

    /**
     * Sets responseFields.
     *
     * @param null|string[] $responseFields Properties to include in the API response of search and browse requests By default, all response properties are included. To reduce the response size, you can select which properties should be included An empty list may lead to an empty API response (except properties you can't exclude) You can't exclude these properties: `message`, `warning`, `cursor`, `abTestVariantID`, or any property added by setting `getRankingInfo` to true Your search depends on the `hits` field. If you omit this field, searches won't return any results. Your UI might also depend on other properties, for example, for pagination. Before restricting the response size, check the impact on your search experience.
     *
     * @return self
     */
    public function setResponseFields($responseFields)
    {
        $this->container['responseFields'] = $responseFields;

        return $this;
    }

    /**
     * Gets restrictHighlightAndSnippetArrays.
     *
     * @return null|bool
     */
    public function getRestrictHighlightAndSnippetArrays()
    {
        return $this->container['restrictHighlightAndSnippetArrays'] ?? null;
    }

    /**
     * Sets restrictHighlightAndSnippetArrays.
     *
     * @param null|bool $restrictHighlightAndSnippetArrays Whether to restrict highlighting and snippeting to items that at least partially matched the search query. By default, all items are highlighted and snippeted.
     *
     * @return self
     */
    public function setRestrictHighlightAndSnippetArrays($restrictHighlightAndSnippetArrays)
    {
        $this->container['restrictHighlightAndSnippetArrays'] = $restrictHighlightAndSnippetArrays;

        return $this;
    }

    /**
     * Gets restrictSearchableAttributes.
     *
     * @return null|string[]
     */
    public function getRestrictSearchableAttributes()
    {
        return $this->container['restrictSearchableAttributes'] ?? null;
    }

    /**
     * Sets restrictSearchableAttributes.
     *
     * @param null|string[] $restrictSearchableAttributes Restricts a search to a subset of your searchable attributes. Attribute names are case-sensitive.
     *
     * @return self
     */
    public function setRestrictSearchableAttributes($restrictSearchableAttributes)
    {
        $this->container['restrictSearchableAttributes'] = $restrictSearchableAttributes;

        return $this;
    }

    /**
     * Gets ruleContexts.
     *
     * @return null|string[]
     */
    public function getRuleContexts()
    {
        return $this->container['ruleContexts'] ?? null;
    }

    /**
     * Sets ruleContexts.
     *
     * @param null|string[] $ruleContexts Assigns a rule context to the search query [Rule contexts](https://www.algolia.com/doc/guides/managing-results/rules/rules-overview/how-to/customize-search-results-by-platform/#whats-a-context) are strings that you can use to trigger matching rules.
     *
     * @return self
     */
    public function setRuleContexts($ruleContexts)
    {
        $this->container['ruleContexts'] = $ruleContexts;

        return $this;
    }

    /**
     * Gets snippetEllipsisText.
     *
     * @return null|string
     */
    public function getSnippetEllipsisText()
    {
        return $this->container['snippetEllipsisText'] ?? null;
    }

    /**
     * Sets snippetEllipsisText.
     *
     * @param null|string $snippetEllipsisText string used as an ellipsis indicator when a snippet is truncated
     *
     * @return self
     */
    public function setSnippetEllipsisText($snippetEllipsisText)
    {
        $this->container['snippetEllipsisText'] = $snippetEllipsisText;

        return $this;
    }

    /**
     * Gets synonyms.
     *
     * @return null|bool
     */
    public function getSynonyms()
    {
        return $this->container['synonyms'] ?? null;
    }

    /**
     * Sets synonyms.
     *
     * @param null|bool $synonyms whether to take into account an index's synonyms for this search
     *
     * @return self
     */
    public function setSynonyms($synonyms)
    {
        $this->container['synonyms'] = $synonyms;

        return $this;
    }

    /**
     * Gets typoTolerance.
     *
     * @return null|TypoTolerance
     */
    public function getTypoTolerance()
    {
        return $this->container['typoTolerance'] ?? null;
    }

    /**
     * Sets typoTolerance.
     *
     * @param null|TypoTolerance $typoTolerance typoTolerance
     *
     * @return self
     */
    public function setTypoTolerance($typoTolerance)
    {
        $this->container['typoTolerance'] = $typoTolerance;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }
}
