<?php

// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

namespace Algolia\AlgoliaSearch\Model\AbtestingV3;

use Algolia\AlgoliaSearch\Model\AbstractModel;
use Algolia\AlgoliaSearch\Model\ModelInterface;

/**
 * Variant Class Doc Comment.
 *
 * @category Class
 */
class Variant extends AbstractModel implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $modelTypes = [
        'description' => 'string',
        'estimatedSampleSize' => 'int',
        'index' => 'string',
        'trafficPercentage' => 'int',
        'metrics' => '\Algolia\AlgoliaSearch\Model\AbtestingV3\MetricResult[]',
        'metadata' => '\Algolia\AlgoliaSearch\Model\AbtestingV3\VariantMetadata',
        'customSearchParameters' => 'object',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $modelFormats = [
        'description' => null,
        'estimatedSampleSize' => null,
        'index' => null,
        'trafficPercentage' => null,
        'metrics' => null,
        'metadata' => null,
        'customSearchParameters' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'description' => 'description',
        'estimatedSampleSize' => 'estimatedSampleSize',
        'index' => 'index',
        'trafficPercentage' => 'trafficPercentage',
        'metrics' => 'metrics',
        'metadata' => 'metadata',
        'customSearchParameters' => 'customSearchParameters',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'description' => 'setDescription',
        'estimatedSampleSize' => 'setEstimatedSampleSize',
        'index' => 'setIndex',
        'trafficPercentage' => 'setTrafficPercentage',
        'metrics' => 'setMetrics',
        'metadata' => 'setMetadata',
        'customSearchParameters' => 'setCustomSearchParameters',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'description' => 'getDescription',
        'estimatedSampleSize' => 'getEstimatedSampleSize',
        'index' => 'getIndex',
        'trafficPercentage' => 'getTrafficPercentage',
        'metrics' => 'getMetrics',
        'metadata' => 'getMetadata',
        'customSearchParameters' => 'getCustomSearchParameters',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     */
    public function __construct(?array $data = null)
    {
        if (isset($data['description'])) {
            $this->container['description'] = $data['description'];
        }
        if (isset($data['estimatedSampleSize'])) {
            $this->container['estimatedSampleSize'] = $data['estimatedSampleSize'];
        }
        if (isset($data['index'])) {
            $this->container['index'] = $data['index'];
        }
        if (isset($data['trafficPercentage'])) {
            $this->container['trafficPercentage'] = $data['trafficPercentage'];
        }
        if (isset($data['metrics'])) {
            $this->container['metrics'] = $data['metrics'];
        }
        if (isset($data['metadata'])) {
            $this->container['metadata'] = $data['metadata'];
        }
        if (isset($data['customSearchParameters'])) {
            $this->container['customSearchParameters'] = $data['customSearchParameters'];
        }
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function modelTypes()
    {
        return self::$modelTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function modelFormats()
    {
        return self::$modelFormats;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!isset($this->container['description']) || null === $this->container['description']) {
            $invalidProperties[] = "'description' can't be null";
        }
        if (!isset($this->container['index']) || null === $this->container['index']) {
            $invalidProperties[] = "'index' can't be null";
        }
        if (!isset($this->container['trafficPercentage']) || null === $this->container['trafficPercentage']) {
            $invalidProperties[] = "'trafficPercentage' can't be null";
        }
        if (!isset($this->container['metrics']) || null === $this->container['metrics']) {
            $invalidProperties[] = "'metrics' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets description.
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'] ?? null;
    }

    /**
     * Sets description.
     *
     * @param string $description description for this variant
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets estimatedSampleSize.
     *
     * @return null|int
     */
    public function getEstimatedSampleSize()
    {
        return $this->container['estimatedSampleSize'] ?? null;
    }

    /**
     * Sets estimatedSampleSize.
     *
     * @param null|int $estimatedSampleSize Estimated number of searches required to achieve the desired statistical significance.  The A/B test configuration must include a `minimumDetectableEffect` setting for this number to be included in the response.
     *
     * @return self
     */
    public function setEstimatedSampleSize($estimatedSampleSize)
    {
        $this->container['estimatedSampleSize'] = $estimatedSampleSize;

        return $this;
    }

    /**
     * Gets index.
     *
     * @return string
     */
    public function getIndex()
    {
        return $this->container['index'] ?? null;
    }

    /**
     * Sets index.
     *
     * @param string $index index name of the A/B test variant (case-sensitive)
     *
     * @return self
     */
    public function setIndex($index)
    {
        $this->container['index'] = $index;

        return $this;
    }

    /**
     * Gets trafficPercentage.
     *
     * @return int
     */
    public function getTrafficPercentage()
    {
        return $this->container['trafficPercentage'] ?? null;
    }

    /**
     * Sets trafficPercentage.
     *
     * @param int $trafficPercentage percentage of search requests each variant receives
     *
     * @return self
     */
    public function setTrafficPercentage($trafficPercentage)
    {
        $this->container['trafficPercentage'] = $trafficPercentage;

        return $this;
    }

    /**
     * Gets metrics.
     *
     * @return MetricResult[]
     */
    public function getMetrics()
    {
        return $this->container['metrics'] ?? null;
    }

    /**
     * Sets metrics.
     *
     * @param MetricResult[] $metrics all ABTest metrics that were defined during test creation
     *
     * @return self
     */
    public function setMetrics($metrics)
    {
        $this->container['metrics'] = $metrics;

        return $this;
    }

    /**
     * Gets metadata.
     *
     * @return null|VariantMetadata
     */
    public function getMetadata()
    {
        return $this->container['metadata'] ?? null;
    }

    /**
     * Sets metadata.
     *
     * @param null|VariantMetadata $metadata metadata
     *
     * @return self
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets customSearchParameters.
     *
     * @return null|object
     */
    public function getCustomSearchParameters()
    {
        return $this->container['customSearchParameters'] ?? null;
    }

    /**
     * Sets customSearchParameters.
     *
     * @param null|object $customSearchParameters Search parameters applied to this variant when the same index is used for multiple variants. Only present if custom search parameters were provided during test creation.
     *
     * @return self
     */
    public function setCustomSearchParameters($customSearchParameters)
    {
        $this->container['customSearchParameters'] = $customSearchParameters;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }
}
