<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;


class ApproveChallengeList extends ListResource
    {
    /**
     * Construct the ApproveChallengeList
     *
     * @param Version $version Version that contains the resource
     * @param string $serviceSid The unique SID identifier of the Service.
     */
    public function __construct(
        Version $version,
        string $serviceSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'serviceSid' =>
            $serviceSid,
        
        ];

        $this->uri = '/Services/' . \rawurlencode($serviceSid)
        .'/Passkeys/ApproveChallenge';
    }

    /**
     * Update the ApproveChallengeInstance
     *
     * @param ApprovePasskeysChallengeRequest $approvePasskeysChallengeRequest
     * @return ApproveChallengeInstance Updated ApproveChallengeInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(ApprovePasskeysChallengeRequest $approvePasskeysChallengeRequest): ApproveChallengeInstance
    {

        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $approvePasskeysChallengeRequest->toArray();
        $payload = $this->version->update('POST', $this->uri, [], $data, $headers);

        return new ApproveChallengeInstance(
            $this->version,
            $payload,
            $this->solution['serviceSid']
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Verify.V2.ApproveChallengeList]';
    }
}
