<?php

// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

namespace Algolia\AlgoliaSearch\Model\AbtestingV3;

use Algolia\AlgoliaSearch\Model\AbstractModel;
use Algolia\AlgoliaSearch\Model\ModelInterface;

/**
 * MetricsFilter Class Doc Comment.
 *
 * @category Class
 *
 * @description Boolean filter applied to the A/B test population. Each filter targets a boolean metric and decides whether to include (true) or exclude (false) matching records.
 */
class MetricsFilter extends AbstractModel implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $modelTypes = [
        'domain' => 'string',
        'name' => 'string',
        'trackEffects' => 'bool',
        'includes' => 'bool',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $modelFormats = [
        'domain' => null,
        'name' => null,
        'trackEffects' => null,
        'includes' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'domain' => 'domain',
        'name' => 'name',
        'trackEffects' => 'trackEffects',
        'includes' => 'includes',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'domain' => 'setDomain',
        'name' => 'setName',
        'trackEffects' => 'setTrackEffects',
        'includes' => 'setIncludes',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'domain' => 'getDomain',
        'name' => 'getName',
        'trackEffects' => 'getTrackEffects',
        'includes' => 'getIncludes',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     */
    public function __construct(?array $data = null)
    {
        if (isset($data['domain'])) {
            $this->container['domain'] = $data['domain'];
        }
        if (isset($data['name'])) {
            $this->container['name'] = $data['name'];
        }
        if (isset($data['trackEffects'])) {
            $this->container['trackEffects'] = $data['trackEffects'];
        }
        if (isset($data['includes'])) {
            $this->container['includes'] = $data['includes'];
        }
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function modelTypes()
    {
        return self::$modelTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function modelFormats()
    {
        return self::$modelFormats;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!isset($this->container['domain']) || null === $this->container['domain']) {
            $invalidProperties[] = "'domain' can't be null";
        }
        if (!isset($this->container['name']) || null === $this->container['name']) {
            $invalidProperties[] = "'name' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets domain.
     *
     * @return string
     */
    public function getDomain()
    {
        return $this->container['domain'] ?? null;
    }

    /**
     * Sets domain.
     *
     * @param string $domain metric domain (for example `abtesting`, `personalization`)
     *
     * @return self
     */
    public function setDomain($domain)
    {
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'] ?? null;
    }

    /**
     * Sets name.
     *
     * @param string $name public metric name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets trackEffects.
     *
     * @return null|bool
     */
    public function getTrackEffects()
    {
        return $this->container['trackEffects'] ?? null;
    }

    /**
     * Sets trackEffects.
     *
     * @param null|bool $trackEffects whether the experiment should record the effects of this filter
     *
     * @return self
     */
    public function setTrackEffects($trackEffects)
    {
        $this->container['trackEffects'] = $trackEffects;

        return $this;
    }

    /**
     * Gets includes.
     *
     * @return null|bool
     */
    public function getIncludes()
    {
        return $this->container['includes'] ?? null;
    }

    /**
     * Sets includes.
     *
     * @param null|bool $includes if true, keep items that match the filter; if false, exclude them
     *
     * @return self
     */
    public function setIncludes($includes)
    {
        $this->container['includes'] = $includes;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }
}
