<?php

// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

namespace Algolia\AlgoliaSearch\Configuration;

class SearchConfig extends Configuration
{
    protected $clientName = 'Search';

    private $defaultWaitTaskTimeBeforeRetry = 5000; // 5 sec in milliseconds
    private $defaultMaxRetries = 50;

    public static function create($appId, $apiKey)
    {
        $config = [
            'appId' => $appId,
            'apiKey' => $apiKey,
        ];

        return new static($config);
    }

    public function setWaitTaskTimeBeforeRetry($waitTaskTimeBeforeRetry)
    {
        $this->config['waitTaskTimeBeforeRetry'] = $waitTaskTimeBeforeRetry;

        return $this;
    }

    public function getWaitTaskTimeBeforeRetry()
    {
        return $this->config['waitTaskTimeBeforeRetry'];
    }

    /**
     * Sets the max retries value used in the Search helpers (e.g. replaceAllobjects).
     *
     * @param number $maxRetries the user agent of the api client
     *
     * @return $this
     */
    public function setMaxRetries($maxRetries)
    {
        $this->config['defaultMaxRetries'] = $maxRetries;

        return $this;
    }

    public function getDefaultMaxRetries()
    {
        return $this->config['defaultMaxRetries'];
    }

    /**
     * Sets the region of the current algolia application to the configuration, this is required to be called if you wish to leverage the transformation pipeline (via the *WithTransformation methods).
     *
     * @param string $region the user agent of the api client
     *
     * @return $this
     */
    public function setTransformationRegion($region)
    {
        $this->config['region'] = $region;

        return $this;
    }

    public function getTransformationRegion()
    {
        return $this->config['region'];
    }

    public function getDefaultConfiguration()
    {
        return [
            'appId' => '',
            'apiKey' => '',
            'hosts' => null,
            'hasFullHosts' => false,
            'readTimeout' => 5,
            'writeTimeout' => 30,
            'connectTimeout' => 2,
            'defaultHeaders' => [],
            'region' => null,
            'waitTaskTimeBeforeRetry' => $this->defaultWaitTaskTimeBeforeRetry,
            'defaultMaxRetries' => $this->defaultMaxRetries,
            'defaultForwardToReplicas' => null,
            'batchSize' => 1000,
        ];
    }
}
